local sampev = require 'lib.samp.events'

radars = {}

function main()
    if not isSampLoaded() or not isSampfuncsLoaded() then return end
    while not isSampAvailable() do wait(100) end
    wait(-1)
end


function sampev.onSendVehicleSync(data)
    if checkdist(radars,data.position) < 30 then
        data.moveSpeed.x = -0.11308368295431
        data.moveSpeed.y = -0.63233608007431
        data.moveSpeed.z = 3.0089278880041e-05
    end
end


function sampev.onCreate3DText(id,color,position,dist,testLOS,attachedPlayerId,attachedVehicleId,text)
    if color == -1 and text:find("%s* : {D1DE43}%d+ /.{FFFFFF}%s*  : {D1DE43}%d+%$.{FFFFFF}%s*: {D1DE43}.*") then
        if not checkIntable(radars, position.x,position.y,position.z) then
            table.insert(radars,{position.x,position.y,position.z})
        end
        return {id,color,position,1000,testLOS,attachedPlayerId,attachedVehicleId,text}
    end
end

function checkIntable(t, r1,r2,r3)
    for _, v in ipairs(t) do
        if (v[1] == r1) and (v[2] == r2) and (v[3] == r3) then return true end
    end
    return false
end

function checkdist(t,h)
local f = 10000
    for _, v in ipairs(t) do
        local distance = getDistanceBetweenCoords3d(v[1], v[2], v[3], h.x, h.y, h.z)
        if distance < f then
            f = distance
        end
    end
return f
end